/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.ucode;

import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.launch.ucode.UcodeSurveyException;
import com.ibm.hsc.websm.launch.ucode.UcodeSurveyProperties;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UcodeSurveyDownload {
    private static final String TRACE_MASKD = "JUCODESD";
    private static final String TRACE_MASKF = "JUCODESF";
    private static final String TRACE_MASKT = "JUCODEST";
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    private static final short ERRID_0003 = 3;
    private static final String DOWNLOAD_FTP_SCRIPT = "/var/adm/invscout/getRemoteFirmwareFile";
    private static final String DOWNLOAD_CDROM_SCRIPT = "/var/adm/invscout/getFileFromCDROM";
    private static final String FRUCODE_CMD = "/opt/hsc/bin/frucode";
    private static final String HMC_FILE = "/opt/hsc/bin/hsc";
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";
    private static final String SERVICE_TARGET_DIRECTORY = "/var/adm/invscout/microcode/";
    private static final String SURVEY_TARGET_DIRECTORY = "/var/adm/invscout/";
    private static final String SURVEY_TARGET_FILE_SUFFIX = ".mup";
    private static final String LICENSE_TARGET_FILE_SUFFIX = ".mic";
    private static final String RPM_FILENAME = "*.rpm";
    private static final String CHMOD_COMMAND = "chmod 666 ";
    private static final String SUCCESSFUL_COPY = "Successful copy of Frame corrective service data file";
    private static boolean _fromCDROM = false;
    private static boolean _fromFtpSite = false;
    private static boolean _fromHttpSite = false;

    private static StringBuffer parsePassword(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                stringBuffer.append(c);
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else if (c == '`' || c == '$' || c == '\"' || c == '\'' || c == ';' || c == '|' || c == '<' || c == '>' || c == '(' || c == ')' || c == '&') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer;
    }

    public static Boolean runningOnHMC() {
        String string = UcodeSurveyProperties.getProperty("location");
        if (string.equals("hmc")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static String processErrorCode(int n) {
        String string;
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.processErrorCode()");
        switch (n) {
            case 2: {
                string = "0020";
                break;
            }
            case 3: {
                string = "0021";
                break;
            }
            case 4: {
                string = "0022";
                break;
            }
            case 8: {
                string = "0023";
                break;
            }
            case 9: {
                string = "0052";
                break;
            }
            default: {
                string = "0024";
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.processErrorCode()");
        return string;
    }

    public static void getFileFromCDROM(String string) throws UcodeSurveyException {
        String string2;
        String string3;
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getFileFromCDROM()");
        EExecResult eExecResult = null;
        _fromCDROM = true;
        _fromFtpSite = false;
        _fromHttpSite = false;
        if (UcodeSurveyDownload.runningOnHMC().booleanValue()) {
            string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt(DOWNLOAD_CDROM_SCRIPT) + " " + string + " " + SERVICE_TARGET_DIRECTORY;
        } else {
            string2 = UcodeSurveyProperties.getProperty("cdromlocation");
            string3 = "/var/adm/invscout/getFileFromCDROM " + string + " " + SERVICE_TARGET_DIRECTORY + " " + string2;
        }
        Trace.trace(TRACE_MASKD, "About to issue command: <" + string3 + ">");
        try {
            eExecResult = EExec.Exec((String)string3);
            if (eExecResult.rc != 0) {
                Trace.trace(TRACE_MASKF, "Command " + string3 + " failed with a rc of " + eExecResult.rc + ".");
                string2 = UcodeSurveyDownload.processErrorCode(eExecResult.rc);
                Trace.trace(TRACE_MASKF, "Throwing exception " + string2);
                throw new UcodeSurveyException(string2);
            }
            Trace.trace(TRACE_MASKF, "File, " + string + " successfully copied from CDROM");
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
            throw ucodeSurveyException;
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "Caught generic exception " + exception);
            throw new UcodeSurveyException("0025");
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getFileFromCDROM()");
    }

    public static void getFileFromFtpSite(String string, String string2, String string3, String string4) throws UcodeSurveyException {
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getFileFromFtpSite()");
        EExecResult eExecResult = null;
        try {
            String string5;
            String string6;
            StringBuffer stringBuffer = UcodeSurveyDownload.parsePassword(string);
            StringBuffer stringBuffer2 = UcodeSurveyDownload.parsePassword(string2);
            StringBuffer stringBuffer3 = UcodeSurveyDownload.parsePassword(string3);
            StringBuffer stringBuffer4 = UcodeSurveyDownload.parsePassword(string4);
            _fromCDROM = false;
            _fromFtpSite = true;
            _fromHttpSite = false;
            if (UcodeSurveyDownload.runningOnHMC().booleanValue()) {
                string6 = "/opt/hsc/bin/hscdc " + Crypt.encrypt(DOWNLOAD_FTP_SCRIPT) + " " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " " + stringBuffer4 + " " + SERVICE_TARGET_DIRECTORY;
                string5 = "/opt/hsc/bin/hscdc " + Crypt.encrypt(DOWNLOAD_FTP_SCRIPT) + " " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " ******** " + SERVICE_TARGET_DIRECTORY;
            } else {
                string6 = "/var/adm/invscout/getRemoteFirmwareFile " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " " + stringBuffer4 + " " + SERVICE_TARGET_DIRECTORY;
                string5 = "/var/adm/invscout/getRemoteFirmwareFile " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " ******** " + SERVICE_TARGET_DIRECTORY;
            }
            Trace.trace(TRACE_MASKD, "About to issue command: <" + string5 + ">");
            eExecResult = EExec.Exec((String)string6);
            if (eExecResult.rc != 0) {
                Trace.trace(TRACE_MASKF, "Command " + string5 + " failed with a rc of " + eExecResult.rc + ".");
                String string7 = UcodeSurveyDownload.processErrorCode(eExecResult.rc);
                Trace.trace(TRACE_MASKF, "Throwing exception " + string7);
                throw new UcodeSurveyException(string7);
            }
            Trace.trace(TRACE_MASKF, "File, " + string2 + " successfully ftp'd");
            eExecResult = EExec.Exec((String)("chmod 666 /var/adm/invscout/microcode/" + string2));
            if (eExecResult.rc != 0) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Command chmod 666 /var/adm/invscout/microcode/" + string2 + " completed with a rc of " + eExecResult.rc + ".");
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
            throw ucodeSurveyException;
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "Caught generic exception " + exception);
            throw new UcodeSurveyException("0025");
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getFileFromFtpSite()");
    }

    public static void getFileFromHttpSite(String string) throws UcodeSurveyException {
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getFileFromHttpSite()");
        EExecResult eExecResult = null;
        try {
            int n;
            int n2;
            HttpURLConnection httpURLConnection;
            _fromCDROM = false;
            _fromFtpSite = false;
            _fromHttpSite = true;
            String string2 = UcodeSurveyProperties.getProperty("weburl");
            String string3 = string2 + string;
            Trace.trace(TRACE_MASKF, "-- urlToFetch is " + string3);
            try {
                URL uRL = new URL(string3);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setAllowUserInteraction(false);
                httpURLConnection.setRequestProperty("Referer", string3);
                httpURLConnection.connect();
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{string3};
                Trace.trace(TRACE_MASKF, "Error reading website: " + string2);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0055", objectArray));
            }
            Trace.trace(TRACE_MASKF, "-- HttpURLConnection.connect() request successful.");
            if (httpURLConnection.getResponseCode() != 200) {
                Object[] objectArray = new Object[]{httpURLConnection.getResponseMessage()};
                Trace.trace(TRACE_MASKF, "Error reading  " + string3 + ": " + objectArray[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0039", objectArray));
            }
            if (!httpURLConnection.getContentType().equals("application/octet-stream")) {
                Object[] objectArray = new Object[]{httpURLConnection.getContentType()};
                Trace.trace(TRACE_MASKF, "Error reading  " + string3 + ": " + objectArray[0]);
            }
            String string4 = (n2 = string3.lastIndexOf("/")) != -1 ? string3.substring(n2 + 1) : string3;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(SERVICE_TARGET_DIRECTORY + string4));
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)bufferedOutputStream).close();
            Trace.trace(TRACE_MASKF, "File, " + string + " successfully downloaded from web site");
            eExecResult = EExec.Exec((String)("chmod 666 /var/adm/invscout/microcode/" + string));
            if (eExecResult.rc != 0) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Command chmod 666 /var/adm/invscout/microcode/" + string + " completed with a rc of " + eExecResult.rc + ".");
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
            throw ucodeSurveyException;
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "Caught generic exception " + exception);
            throw new UcodeSurveyException("0025");
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getFileFromHttpSite()");
    }

    public static SurveyFileResult doUcodeSurvey(String string) throws UcodeSurveyException {
        SurveyFileResult surveyFileResult = null;
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.doUcodeSurvey()");
        int n = string.indexOf("_");
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            String string4 = " ";
            String string5 = "";
            int n2 = 0;
            String string6 = " ";
            String string7 = " ";
            EExecResult eExecResult = null;
            String string8 = " ";
            try {
                string5 = UcodeSurveyDownload.getSurveyFileName(string);
                string4 = UcodeSurveyDownload.runningOnHMC() != false ? "/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -f " + string5 : "rm -f " + string5;
                eExecResult = EExec.Exec((String)string4);
                Trace.trace(TRACE_MASKF, "Remove file command <" + string4 + ">, rc = " + eExecResult.rc);
                string4 = UcodeSurveyDownload.runningOnHMC() != false ? "/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -f " + SERVICE_TARGET_DIRECTORY + RPM_FILENAME : "rm -f /var/adm/invscout/microcode/*.rpm";
                eExecResult = EExec.Exec((String)string4);
                Trace.trace(TRACE_MASKF, "Remove rpms command <" + string4 + ">, rc = " + eExecResult.rc);
                string4 = string.equals("0000-000_0000000") ? "/usr/sbin/invscout -mcfs" : "/usr/sbin/invscout -m " + string2 + " -s " + string3;
                eExecResult = EExec.Exec((String)string4);
                if (eExecResult.rc > 7) {
                    Trace.trace(TRACE_MASKF, "Inventory Scout command <" + string4 + "> failed, rc = " + eExecResult.rc);
                    Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                    string8 = eExecResult.stderr;
                    Object[] objectArray = new Object[3];
                    objectArray[1] = Integer.toString(eExecResult.rc);
                    objectArray[0] = string4;
                    objectArray[2] = string8;
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                }
                Trace.trace(TRACE_MASKF, "Inventory Scout command <" + string4 + "> was successful with rc=" + eExecResult.rc);
                n2 = eExecResult.rc;
                eExecResult.rc = 0;
                string6 = eExecResult.stderr;
                string7 = string4;
                surveyFileResult = UcodeSurveyDownload.getDataFile(string5);
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey() + " args:" + ucodeSurveyException.getArgs());
                throw ucodeSurveyException;
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, "Exception caught during survey processing, " + exception);
                String string9 = Integer.toString(eExecResult.rc);
                Object[] objectArray = new Object[3];
                try {
                    objectArray[1] = Integer.toString(eExecResult.rc);
                }
                catch (Exception exception2) {
                    objectArray[1] = Integer.toString(127);
                }
                objectArray[0] = "/usr/sbin/invscout -m";
                objectArray[2] = string8;
                Trace.trace(TRACE_MASKF, "Throwing invscout exception " + objectArray[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.doUcodeSurvey()");
        return surveyFileResult;
    }

    public static String getSurveyFileName(String string) throws UcodeSurveyException {
        String string2 = "";
        String string3 = "";
        EExecResult eExecResult = null;
        if (UcodeSurveyDownload.runningOnHMC().booleanValue()) {
            String string4 = string.equals("0000-000_0000000") ? "frame" : string;
            string2 = SURVEY_TARGET_DIRECTORY + string4 + SURVEY_TARGET_FILE_SUFFIX;
        } else if (string.equals("0000-000_0000000")) {
            string2 = "/var/adm/invscout/frame.mup";
        } else {
            string3 = "hostname -s";
            eExecResult = EExec.Exec((String)string3);
            if (eExecResult.rc != 0) {
                Trace.trace(TRACE_MASKF, "AIX command <" + string3 + "> failed, rc = " + eExecResult.rc);
                Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                String string5 = eExecResult.stderr;
                Object[] objectArray = new Object[3];
                objectArray[1] = Integer.toString(eExecResult.rc);
                objectArray[0] = "hostname -s";
                objectArray[2] = string5;
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
            }
            Trace.trace(TRACE_MASKF, "AIX command <" + string3 + "> was successful");
            String string6 = eExecResult.stdout;
            string2 = SURVEY_TARGET_DIRECTORY + string6.trim() + SURVEY_TARGET_FILE_SUFFIX;
        }
        return string2;
    }

    public static SurveyFileResult getLicenseFile() throws UcodeSurveyException {
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getLicenseFile()");
        String string = SERVICE_TARGET_DIRECTORY + UcodeSurveyProperties.getProperty("licensename");
        SurveyFileResult surveyFileResult = UcodeSurveyDownload.getDataFile(string);
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getLicenseFile()");
        return surveyFileResult;
    }

    public static SurveyFileResult getDataFile(String string) throws UcodeSurveyException {
        BufferedReader bufferedReader;
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getDataFile()");
        Trace.trace(TRACE_MASKT, "Checking for file " + string);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        }
        catch (IOException iOException) {
            Trace.trace(TRACE_MASKT, "Error processing/finding file" + string);
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
            Object[] objectArray = new Object[]{string, iOException.toString()};
            Trace.trace(TRACE_MASKF, "Throwing file io exception " + objectArray[0]);
            throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0004", objectArray));
        }
        SurveyFileResult surveyFileResult = new SurveyFileResult();
        int n = 0;
        if (bufferedReader != null) {
            try {
                surveyFileResult = new SurveyFileResult();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.trim().length() > 0) {
                        surveyFileResult.saveRecord(string2);
                        ++n;
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                try {
                    Trace.trace(TRACE_MASKF, "IO Exception reading survey file: " + iOException);
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
                    Object[] objectArray = new Object[]{string};
                    Trace.trace(TRACE_MASKF, "Throwing file close exception " + objectArray[0]);
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0005", objectArray));
                }
            }
        } else {
            try {
                Trace.trace(TRACE_MASKF, "Error: Survey File was empty");
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
                Object[] objectArray = new Object[]{string};
                Trace.trace(TRACE_MASKF, "Throwing file close exception " + objectArray[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0005", objectArray));
            }
        }
        if (n > 0) {
            Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
            return surveyFileResult;
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getDataFile()");
        Object[] objectArray = new Object[]{string, "File is empty"};
        Trace.trace(TRACE_MASKF, "Throwing file io exception " + objectArray[0]);
        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0004", objectArray));
    }

    public static synchronized void RPMPackageInstall(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws UcodeSurveyException {
        block16: {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.RPMPackageInstall()");
            try {
                File file = new File(string3);
                if (!file.exists() || !file.isFile()) {
                    Trace.trace(TRACE_MASKF, "Downloading/Copying file " + string2 + string3);
                    if (_fromCDROM) {
                        UcodeSurveyDownload.getFileFromCDROM(string2 + string3);
                    }
                    if (_fromFtpSite) {
                        UcodeSurveyDownload.getFileFromFtpSite(string5, string3, string6, string7);
                    }
                    if (_fromHttpSite) {
                        UcodeSurveyDownload.getFileFromHttpSite(string3);
                    }
                }
                EExecResult eExecResult = null;
                eExecResult = EExec.Exec((String)("chmod 666 /var/adm/invscout/microcode/" + string3));
                Trace.trace(TRACE_MASKF, "Command chmod 666 /var/adm/invscout/microcode/" + string3 + " completed with a rc of " + eExecResult.rc + ".");
                int n = string.indexOf("_");
                if (n != -1) {
                    String string8 = string.substring(0, n);
                    String string9 = string.substring(n + 1, string.length());
                    String string10 = null;
                    String string11 = null;
                    if (string4.equals("BPA")) {
                        string10 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("/bin/rpm") + " -i --force " + SERVICE_TARGET_DIRECTORY + string3;
                    } else {
                        string10 = "/usr/sbin/invscout -RPM " + string3 + " -o \"'-i --force'\" -m " + string8 + " -s " + string9 + " -p " + string4;
                        string11 = "/usr/sbin/invscout -RPM " + string3 + " -o \"-i --force\" -m " + string8 + " -s " + string9 + " -p " + string4;
                    }
                    String string12 = " ";
                    try {
                        if (!UcodeSurveyDownload.runningOnHMC().booleanValue()) {
                            string10 = string11;
                        }
                        eExecResult = EExec.Exec((String)string10);
                        if (eExecResult.rc != 0) {
                            Trace.trace(TRACE_MASKF, "Command <" + string10 + "> returned a non-zero return code. rc = " + eExecResult.rc);
                            Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                            string12 = eExecResult.stderr;
                        } else {
                            Trace.trace(TRACE_MASKF, "Inventory Scout command '" + string10 + "' succeeded");
                        }
                    }
                    catch (Throwable throwable) {
                        eExecResult.rc = 127;
                    }
                    if (eExecResult.rc != 0) {
                        Object[] objectArray = new Object[3];
                        objectArray[1] = Integer.toString(eExecResult.rc);
                        objectArray[0] = string10;
                        objectArray[2] = string12;
                        Trace.trace(TRACE_MASKF, "Throwing invscout exception " + objectArray[0]);
                        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                    }
                    break block16;
                }
                Trace.trace(TRACE_MASKF, "-- input parameter error, malformed MTMS is: <" + string + ">");
                Object[] objectArray = new Object[]{string};
                Trace.trace(TRACE_MASKF, "Throwing mtms exception " + objectArray[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0045", objectArray));
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                Trace.trace(TRACE_MASKF, "Caught inner UcodeSurveyException " + ucodeSurveyException.getKey());
                throw ucodeSurveyException;
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, "-- Exception caught is: " + exception);
                throw new UcodeSurveyException("0025");
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.RPMPackageInstall()");
    }

    public static void RPMPackageErase(String string, String string2, String string3) throws UcodeSurveyException {
        block9: {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.RPMPackageErase()");
            try {
                int n = string.indexOf("_");
                EExecResult eExecResult = null;
                if (n != -1) {
                    String string4 = string.substring(0, n);
                    String string5 = string.substring(n + 1, string.length());
                    n = string2.lastIndexOf(".");
                    if (n != -1) {
                        String string6 = string2.substring(0, n);
                        String string7 = string3.equals("BPA") ? "/opt/hsc/bin/hscdc " + Crypt.encrypt("/bin/rpm") + " -e " + string6 : new String("/usr/sbin/invscout -RPM " + string6 + " -o \"'-e'\" -m " + string4 + " -s " + string5 + " -p " + string3);
                        String string8 = null;
                        try {
                            eExecResult = EExec.Exec((String)string7);
                            if (eExecResult.rc != 0) {
                                Trace.trace(TRACE_MASKF, "Inventory Scout command " + string7 + " returned a non-zero return code. rc = " + eExecResult.rc);
                                Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                                string8 = eExecResult.stderr;
                            } else {
                                Trace.trace(TRACE_MASKF, "Inventory Scout command '" + string7 + "' succeeded");
                            }
                        }
                        catch (Exception exception) {
                            eExecResult.rc = 127;
                            Object[] objectArray = new Object[3];
                            objectArray[1] = Integer.toString(eExecResult.rc);
                            objectArray[0] = string7;
                            objectArray[2] = string8;
                            Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                            throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                        }
                        if (eExecResult.rc != 0) {
                            Object[] objectArray = new Object[3];
                            objectArray[1] = Integer.toString(eExecResult.rc);
                            objectArray[0] = string7;
                            objectArray[2] = string8;
                            Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                            throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                        }
                        break block9;
                    }
                    Trace.trace(TRACE_MASKF, "-- input parameter error, malformed rpmFile is: <" + string2 + ">");
                    Object[] objectArray = new Object[]{string2};
                    Trace.trace(TRACE_MASKF, "Throwing rpmfile exception " + objectArray[0]);
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0046", objectArray));
                }
                Trace.trace(TRACE_MASKF, "-- input parameter error, malformed MTMS is: <" + string + ">");
                Object[] objectArray = new Object[]{string};
                Trace.trace(TRACE_MASKF, "Throwing rpmfile exception " + objectArray[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0045", objectArray));
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, "-- Exception caught is: " + exception);
                throw new UcodeSurveyException("0048");
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.RPMPackageErase()");
    }

    public static String RPMPackageQuery(String string, String string2, String string3, String string4, String string5) throws UcodeSurveyException {
        String string6;
        block11: {
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.RPMPackageQuery()");
            string6 = null;
            EExecResult eExecResult = null;
            String string7 = " ";
            try {
                int n;
                String string8 = SERVICE_TARGET_DIRECTORY + string3;
                File file = new File(string8);
                if (!file.exists() || !file.isFile()) {
                    Trace.trace(TRACE_MASKF, "Downloading/Copying file " + string8);
                    if (_fromCDROM) {
                        UcodeSurveyDownload.getFileFromCDROM(string2 + string3);
                    }
                    if (_fromFtpSite) {
                        UcodeSurveyDownload.getFileFromFtpSite(string, string3, string4, string5);
                    }
                    if (_fromHttpSite) {
                        UcodeSurveyDownload.getFileFromHttpSite(string3);
                    }
                }
                if ((n = string3.lastIndexOf(".")) > 0) {
                    String string9 = UcodeSurveyDownload.runningOnHMC() != false ? "/opt/hsc/bin/hscdc " + Crypt.encrypt("/bin/rpm") + " -qpi " + string8 : new String("/usr/bin/rpm -qpi " + string8);
                    try {
                        eExecResult = EExec.Exec((String)string9);
                        if (eExecResult.rc != 0) {
                            Trace.trace(TRACE_MASKF, "Command " + string9 + " returned a non-zero return code. rc = " + eExecResult.rc);
                            Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                            string7 = eExecResult.stderr;
                        } else {
                            Trace.trace(TRACE_MASKF, "Command '" + string9 + "' succeeded");
                            string6 = eExecResult.stdout.trim();
                            Trace.trace(TRACE_MASKF, "execResult.stdout is <" + string6 + ">");
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        eExecResult.rc = 127;
                        Object[] objectArray = new Object[3];
                        objectArray[1] = Integer.toString(eExecResult.rc);
                        objectArray[0] = string9;
                        objectArray[2] = string7;
                        Trace.trace(TRACE_MASKF, "Throwing invcsout exception " + objectArray[0]);
                        throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
                    }
                }
                Trace.trace(TRACE_MASKF, "-- input parameter error, malformed rpmFile is: <" + string3 + ">");
                Object[] objectArray = new Object[]{string3};
                Trace.trace(TRACE_MASKF, "Throwing rpmfile exception " + objectArray[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0046", objectArray));
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, "-- Exception caught is: " + exception);
                throw new UcodeSurveyException("0050");
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.RPMPackageQuery()");
        return string6;
    }

    public static void ucodeInstall(String string, String string2, String string3, String string4) throws UcodeSurveyException {
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.doUcodeUpdate()");
        boolean bl = false;
        int n = string.indexOf("_");
        if (n != -1) {
            Object[] objectArray;
            String string5 = string.substring(0, n);
            String string6 = string.substring(n + 1, string.length());
            String string7 = string3 == null || string3.length() == 0 ? " " : " -f " + string3;
            String string8 = "";
            String string9 = "";
            if (string4.equals("BPA")) {
                bl = true;
                string8 = "/opt/hsc/bin/hscdc " + Crypt.encrypt(FRUCODE_CMD) + " installframe " + string3 + " -m " + string5 + string6;
                string9 = "/opt/hsc/bin/frucode installframe " + string3 + " -m " + string5 + string6;
            } else {
                bl = false;
                string9 = string8 = "/usr/sbin/invscout -FWM " + string2 + string7 + " -m " + string5 + " -s " + string6 + " -p " + string4;
            }
            EExecResult eExecResult = null;
            String string10 = " ";
            String string11 = " ";
            String string12 = "0";
            try {
                eExecResult = EExec.Exec((String)string8);
                if (bl) {
                    if (eExecResult.rc != 0) {
                        Trace.trace(TRACE_MASKF, "frucode command " + string9 + " returned a non-zero return code. rc = " + eExecResult.rc);
                        Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                        string10 = eExecResult.stderr;
                    } else {
                        string11 = eExecResult.stdout;
                        objectArray = new StringTokenizer(string11, " ");
                        string12 = (String)objectArray.nextElement();
                        Trace.trace(TRACE_MASKF, "frucode command return code was " + string12);
                        if (!string12.equals("0")) {
                            string10 = " ";
                        }
                    }
                } else if (eExecResult.rc > 7) {
                    Trace.trace(TRACE_MASKF, "Inventory Scout command " + string9 + " returned a non-zero return code. rc = " + eExecResult.rc);
                    Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                    string10 = eExecResult.stderr;
                } else {
                    Trace.trace(TRACE_MASKF, "Inventory Scout command '" + string9 + "' succeeded with a return code of " + eExecResult.rc);
                }
            }
            catch (Exception exception) {
                eExecResult.rc = 127;
                Object[] objectArray2 = new Object[3];
                objectArray2[1] = Integer.toString(eExecResult.rc);
                objectArray2[0] = string9;
                objectArray2[2] = string10;
                Trace.trace(TRACE_MASKF, "Throwing ucodeInstall exception " + objectArray2[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray2));
            }
            if (eExecResult.rc > 7 | !string12.equals("0")) {
                if (bl) {
                    objectArray = new Object[]{string9, string12};
                    Trace.trace(TRACE_MASKF, "Throwing ucodeInstall exception " + objectArray[0]);
                    throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0061", objectArray));
                }
                objectArray = new Object[3];
                objectArray[1] = Integer.toString(eExecResult.rc);
                objectArray[0] = string9;
                objectArray[2] = string10;
                Trace.trace(TRACE_MASKF, "Throwing ucodeInstall exception " + objectArray[0]);
                throw new UcodeSurveyException(UcodeSurveyException.TokenizeArgs("0041", objectArray));
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.doUcodeUpdate()");
    }

    public static Vector findUcodeResources() throws UcodeSurveyException {
        Object object;
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.findUcodeResources()");
        Vector vector = null;
        Vector vector2 = UcodeSurveyDownload.findAllCECs();
        if (vector2 != null && vector2.size() > 0) {
            vector = new Vector();
            object = vector2.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
        }
        if (UcodeSurveyDownload.runningOnHMC().booleanValue() && (object = UcodeSurveyDownload.findAllFrames()) != null && ((Vector)object).size() > 0) {
            if (vector == null) {
                vector = new Vector();
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.findUcodeResources()");
        return vector;
    }

    public static Vector findAllCECs() {
        Vector vector = null;
        Vector vector2 = null;
        Vector<String> vector3 = null;
        CECInfo cECInfo = null;
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.findAllCECs()");
        try {
            Enumeration enumeration;
            vector2 = CIMUtils.getCECsInfo();
            if (vector2 != null && vector2.size() > 0) {
                Trace.trace(TRACE_MASKF, "tempVector size is " + vector2.size());
            } else {
                Trace.trace(TRACE_MASKF, "getCECsInfo() returned a vector of size 0, or vector is null");
            }
            if (vector2 != null && vector2.size() > 0) {
                vector = new Vector();
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    cECInfo = (CECInfo)enumeration.nextElement();
                    Trace.trace(TRACE_MASKF, "model type is " + cECInfo.getCECModelType());
                    Trace.trace(TRACE_MASKF, "serial number is " + cECInfo.getCECSerialNumber());
                    Trace.trace(TRACE_MASKF, "machine name is " + cECInfo.getCECMachineName());
                    vector3 = new Vector<String>();
                    vector3.addElement(ResourceItem.resource_cec);
                    vector3.addElement(cECInfo.getCECModelType());
                    vector3.addElement(cECInfo.getCECSerialNumber());
                    vector3.addElement(cECInfo.getCECMachineName());
                    vector.addElement(vector3);
                }
            }
            if (vector != null) {
                Trace.trace(TRACE_MASKD, "getCECsInfo() found the following CECs:");
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Trace.trace(TRACE_MASKD, "CEC found of " + (String)enumeration.nextElement());
                }
            } else {
                Trace.trace(TRACE_MASKD, "getCECsInfo returned null");
            }
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "-- UcodeSurveyDownload.findAllCECs() exception is " + throwable);
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.findAllCECs()");
        return vector;
    }

    public static Vector findAllFrames() {
        Vector vector;
        block10: {
            EExecResult eExecResult = null;
            vector = null;
            Vector<String> vector2 = null;
            Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.findAllFrames()");
            try {
                String string = "/opt/hsc/bin/hscdc " + Crypt.encrypt(FRUCODE_CMD) + " listframes";
                Trace.trace(TRACE_MASKD, "About to issue command: <" + string + ">");
                eExecResult = EExec.Exec((String)string);
                if (eExecResult.rc != 0) {
                    Trace.trace(TRACE_MASKF, "Command " + string + " failed with a rc of " + eExecResult.rc + ".");
                    Trace.trace(TRACE_MASKF, "stderr is <" + eExecResult.stderr + ">");
                    Trace.trace(TRACE_MASKF, "Throwing exception " + eExecResult.rc);
                    break block10;
                }
                Trace.trace(TRACE_MASKF, "Command <" + string + "> completed with no errors.");
                Trace.trace(TRACE_MASKF, "output data is <" + eExecResult.stdout + ">");
                BufferedReader bufferedReader = new BufferedReader(new StringReader(eExecResult.stdout));
                vector = new Vector();
                String string2 = null;
                string2 = bufferedReader.readLine().trim();
                if (string2.length() != 0) {
                    string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        Trace.trace(TRACE_MASKF, "stdout line is: " + string2);
                        if (string2.trim().length() > 0) {
                            try {
                                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                                String string3 = stringTokenizer.nextToken();
                                String string4 = string3.substring(0, 8);
                                String string5 = string3.substring(8);
                                String string6 = stringTokenizer.nextToken();
                                if (string6.equals("65535") || string6.equals("ffff") || string6.equals("FFFF") || string6.equals("-1")) {
                                    Trace.trace(TRACE_MASKF, "mtm is <" + string4 + ">, s/n is <" + string5 + ">, however frame ID is invalid.");
                                    Trace.trace(TRACE_MASKF, "Invalid frame ID return from 'frucode' cmd is: <" + string6 + ">");
                                    Trace.trace(TRACE_MASKF, "No ResourceItem added to table.");
                                } else {
                                    vector2 = new Vector<String>();
                                    Trace.trace(TRACE_MASKF, "mtm is <" + string4 + ">, s/n is <" + string5 + ">, Frame ID is <" + string6 + ">");
                                    vector2.addElement(ResourceItem.resource_bpa);
                                    vector2.addElement(string4);
                                    vector2.addElement(string5);
                                    vector2.addElement(string6);
                                    vector.addElement(vector2);
                                }
                            }
                            catch (Exception exception) {
                                Trace.trace(TRACE_MASKF, "Unexpected exception processing frame data. Exception is " + exception);
                            }
                        }
                        string2 = bufferedReader.readLine();
                    }
                    break block10;
                }
                Trace.trace(TRACE_MASKF, "No data returned from BPA query.");
            }
            catch (Exception exception) {
                Trace.trace(TRACE_MASKF, "-- UcodeSurveyDownload.findAllFrames() exception is " + exception);
            }
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.findAllFrames()");
        return vector;
    }

    private static String getLogFile(String string) {
        Trace.trace(TRACE_MASKT, "-> UcodeSurveyDownload.getLogFile()");
        String string2 = null;
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            string2 = new String(byArray);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "The requested log file: " + string + " could not be read.");
        }
        Trace.trace(TRACE_MASKT, "<- UcodeSurveyDownload.getLogFile()");
        return string2;
    }
}

